Framework = {}

Framework.Proxy = module('vrp','lib/Proxy')
Framework.vRP = Framework.Proxy.getInterface('vRP')

Framework.Functions = {
    GetUserId = function(self,playerSource)
        return Framework.vRP.Passport(playerSource)
    end,

    GiveItem = function(self, userId, item, amount, rewardType)
        local playerSource = Framework.vRP.Source(userId)
        if rewardType == 'item' then
            Framework.vRP.GiveItem(userId,item,amount)
            TriggerClientEvent('Notify',playerSource,'verde','Você recebeu <b>'..item..' '..amount..'x</b>.', 5000)
        elseif rewardType == 'vehicle' then
            Framework.vRP.execute('vehicles/addVehicles',{
                userId = userId,
                vehicle = item,
                plate = Framework.vRP.GeneratePlate(),
                work = tostring(false)
            });
            TriggerClientEvent('Notify',playerSource,'verde','Você recebeu o veículo <b>'..item..'</b>, vá até a sua garagem para utiliza-lo.', 5000)
        elseif rewardType == 'vip' then
            local vipFile = json.decode(LoadResourceFile(GetCurrentResourceName(), 'config/Vips.json'))
            if vipFile[item] then
                for _,v in pairs(vipFile[item].items) do
                    Framework.vRP.GiveItem(userId,v.spawn,v.amount)
                end
                for _,v in pairs(vipFile[item].vehicles) do
                    Framework.vRP.Query('vehicles/addVehicles',
                    {
                        userId = userId,
                        vehicle = v,
                        plate = Framework.vRP.GeneratePlate(),
                        work = tostring(false)
                    });
                end
                for _,v in pairs(vipFile[item].groups) do
                    Framework.vRP.SetPermission(userId, v);
                end
            end
            TriggerClientEvent('Notify',playerSource,'verde','Você coletou um <b>'..item..'</b> e recebeu diversos beneficios.', 5000)
        end
    end,

    HasPermission = function(self,userId,permission)
        return Framework.vRP.HasGroup(userId,permission)
    end,

    Query = function(self,query,params)
        return MySQL.query.await(query,params)
    end
}
