Framework = {}

Framework.Proxy = module('vrp','lib/Proxy')
Framework.Tunnel = module('vrp','lib/Tunnel')

Framework.vRP = Framework.Proxy.getInterface('vRP')
Framework.vRPC = Framework.Tunnel.getInterface('vRP')

Framework.Functions = { 
    GetUserId = function(self, player_source)
        local user_id = Framework.vRP.Passport(player_source)
        return user_id
    end,

    GetUserIdentity = function(self,user_id)
        local user_identity = Framework.vRP.Identity(user_id)
        return { name = user_identity['name'], surname = user_identity['name2'] }
    end,

    GetUserGems = function(self, user_id)
        local player_source = Framework.vRP.Source(user_id)
        if player_source then
            local license = Framework.vRP.Identities(player_source)
            return Framework.vRP.UserGemstone(license) or 0
        end
    end,

    GetNearestVehicle = function(self, user_id) 
        local player_source = Framework.vRP.Source(user_id)
        if player_source then
            local Vehicle,Network,Plate = Framework.vRPC.VehicleList(player_source, 5)
            if Vehicle then
                if GlobalState["Plates"][Plate] == user_id then
                    return Network
                end
            end
        end

        return false
    end
}