Framework = {}

Framework.Proxy = module('vrp','lib/Proxy')
Framework.vRP = Framework.Proxy.getInterface('vRP')

Framework.Functions = {
    GetUserId = function(playerSource)
        return Framework.vRP.Passport(playerSource)
    end,

    Query = function(query,params)
        return MySQL.query.await(query,params)
    end,

    Permission = function(userId, permission)
        return Framework.vRP.HasPermission(userId, permission)
    end,

    Payment = function(userId, value)
        return Framework.vRP.PaymentBank(userId, value)
    end,

    Notify = function(userId, type, message)
        local playerSource = Framework.vRP.Source(userId)

        TriggerClientEvent("Notify", playerSource, (type == "success" and "verde" or "vermelho"), message, 4000)
    end,

    SaveClothing = function(userId, value)
        local playerSource = Framework.vRP.Source(userId)
        local dictionary = {}
        local map = {
            ["1"] = "mask",
            ["3"] = "arms",
            ["4"] = "pants",
            ["5"] = "backpack",
            ["6"] = "shoes",
            ["7"] = "accessory",
            ["8"] = "tshirt",
            ["9"] = "vest",
            ["10"] = "decals",
            ["11"] = "torso",
            ["p0"] = "hat",
            ["p1"] = "glass",
            ["p2"] = "ear",
            ["p6"] = "watch",
            ["p7"] = "accessory"
        }

        for k,v in pairs(value) do
            dictionary[map[k]] = { item = v[1], texture = v[2] }
        end

        TriggerClientEvent("skinshop:Apply", playerSource, dictionary)
        Framework.vRP.Query("playerdata/SetData", { Passport = userId, dkey = "Clothings", dvalue = json.encode(dictionary) })
    end
}