Config = json.decode(LoadResourceFile(GetCurrentResourceName(), "config/Config.json")) or {}
Locales = json.decode(LoadResourceFile(GetCurrentResourceName(), "config/Locales.json")) or {}

Tunnel = {
    TableMaxn = function(self, t)
        local max = 0
        for k,v in pairs(t) do
            local n = tonumber(k)
            if n and n > max then max = n end
        end
        return max
    end,

    BindInterface = function(self, identifier, interface)
        RegisterServerEvent(identifier..':tunnel_req',function(name,data,identifier,rid)
            local source = source

            local handler = interface[name]

            local rets = {}
            if type(handler) == 'function' then
                rets = { handler(table.unpack(data,1,self:TableMaxn(data))) }
            end

            if rid and rid >= 0 then
                TriggerClientEvent(identifier..':tunnel_res',source,rid,rets,name)
            end
        end)
    end
}

vFunc = {}
Tunnel:BindInterface(GetCurrentResourceName(), vFunc)

local Authenticated = false
local TryAuth = false
local IsTebex = false
local ClientModule = ""

local function _XRESS(data)
    Authenticated = true

    if data then
        local func, err = load(data.server)

        ClientModule = data.client

        if func then
            func()
        end
    end
end

vFunc.ReceiveClientModule = function()
    return ClientModule
end

vFunc.IsAuth = function()
    return Authenticated
end

vFunc.AuthClient = function(endpoint)
    if not Authenticated and not TryAuth then
        TryAuth = true

        local ip, port = string.match(endpoint, '(.-):(.+)')
        if ip and port then
            PerformHttpRequest('https://auth-fivem.onesourceteam.dev/licenses/verify/', function(error_code, result_data)
                if result_data then
                    local data = json.decode(result_data)

                    if data.token or IsTebex then
                        if data.token then
                            print('[OS] - Script authenticated via IP! License: '..data.licenseLeft)
                            if data.newVersion then
                                print('[OS] - A new version ^2('..data.newVersion..')^7 of this scripts is avalable. Use:')
                                print(GetCurrentResourceName()..' --update ^3'..data.newVersion..'^7')
                            end

                            return _XRESS(data.scriptModule)
                        elseif IsTebex then
                            print('[OS] - Script authenticated via TEBEX! License: Permanent')

                            if data.newVersion then
                                print('[OS] - A new version ^2('..data.newVersion..')^7 of this scripts is avalable. Use:')
                                print(GetCurrentResourceName()..' --update ^3'..data.newVersion..'^7')
                            end

                            return _XRESS(data.scriptModule)
                        end
                    end

                    print('[OS] - Script authentication failed!', data.error)
                else
                    if IsTebex then
                        print('[OS] - Script authenticated via TEBEX! License: Permanent')
                        return _XRESS(data.scriptModule)
                    else
                        print('[OS] - Invalid authentication parameters!')
                    end
                end
            end, 'POST', json.encode({ server_ip = ip, server_port = tonumber(port), license_key = Config.LicenseKey, script = GetCurrentResourceName(), hostName = GetConvar('sv_hostname'), projectName =  GetConvar('sv_projectName'), projectDesc =  GetConvar('sv_projectDesc'), maxclients = GetConvarInt('sv_maxclients') ,licenseKey = GetConvar('sv_licenseKey') }),{ ['Content-Type'] = 'application/json' })
        end
    end
end